--Mounting 3d model paths and texture paths 

mount_vfs_model_path (current_mod_path.."/Shapes")
mount_vfs_texture_path (current_mod_path.."/Textures/Civil_Textures.zip")

--Vehicle Type - Fire Truck 1

GT_t.CH_t.Firetruck_1 = {
    life = 1.5,
	mass = 1000,
	length = 4.5,
	width = 2.0,
	max_road_velocity = 100.0000,
	max_slope = 0.47,
	fordingDepth = 0.8,
	engine_power = 700,
	gear_count = 5,
	max_vert_obstacle = 0.6,
	max_acceleration = 4.0,
	min_turn_radius = 5.5,
	X_gear_1 = 2.411,
	Y_gear_1 = 0,
	Z_gear_1 = 1.04,
	X_gear_2 = -2.549,
	Y_gear_2 = 0,
	Z_gear_2 = 1.04,
	gear_type = GT_t.GEAR_TYPES.WHEELS,
	r_max = 0.67,
	armour_thickness = 0.001,
};

GT = {};
GT_t.ws = 0;
set_recursive_metatable(GT, GT_t.generic_wheel_vehicle);
set_recursive_metatable(GT.chassis, GT_t.CH_t.Firetruck_1);

--Turbine

GT.turbine = false;

--Sound

GT.sound = {};

--Engine params

GT.sound.engine = {};
GT.sound.engine.idle = "GndTech/DieselEngineIdle";
GT.sound.engine.max = "GndTech/DieselEngineMax";

GT.sound.engine.acc_start = "GndTech/TruckStarter";
GT.sound.engine.acc_end = "GndTech/WarriorEngineAccEnd";

GT.sound.engine.idle_formula_gain = "0.2 x * 1 +";
GT.sound.engine.idle_formula_pitch = "1.2436 x * 0.7564 +";

GT.sound.engine.max_formula_gain = "0.9 x * 0.1 +";
GT.sound.engine.max_formula_pitch = "0.4363 x * 0.5637 +";

--Move params

GT.sound.move = {};
GT.sound.move.sound = "GndTech/TruckMove";
GT.sound.move.pitch = {{0.0, 0.6}, {10.0, 1.2}};
GT.sound.move.gain = {{0.0, 0.01}, {0.5, 0.5}, {12.0, 0.9}};

GT.sound.noise = {};
GT.sound.noise.sound = "Damage/VehHit";

GT.visual.shape = "Civ_Fire_Truck_1_Lit"
GT.visual.shape_dstr = "destr"

--Burning after hit

GT.visual.fire_size = 0 --relative burning size
GT.visual.fire_pos = {0,0,0};
GT.visual.fire_time = 80 --burning time (seconds)
GT.time_agony = 5;

GT.Name = "Civ_Fire_Truck_1_Lit"
GT.DisplayName = _("Civ Vehicle Fire Tender 1")
GT.Rate = 0

GT.DetectionRange  = 0;
GT.ThreatRange = 0;
GT.mapclasskey = "P0091000212";

GT.attribute = {wsType_Ground,wsType_Tank,wsType_NoWeapon,wsTypeUAZ469,
				"Cars",
				"human_vehicle",
				};
GT.category = "Unarmed";

add_surface_unit(GT)

-- End